IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cbtes_Ctas_Contables_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Ctas_Contables_Generar
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Ctas_Contables_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Ctas_Contables_Generar_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    EXEC [CPJ_Cbtes_Ctas_Contables_Generar_] @pJson
	RETURN
END


/*
 * LOG VERSIONES:
 * 05/05/2022: En el Debe cuando habia un producto desplegado en meses ponia el importe de solo un periodo
 * 30/6/2022: En el debe se coloca centro de costo vacio

 * 3/11/2022 Centros de costos
   Asi_CC_Req_Resul   par global de todas las ctas.result

   Prioridades para centro de costos del producto
           CBT:Id_Centro_Costo
           CLI:Id_Centro_Costo
           SUC:Id_Centro_Costo
       deberiamos recibir el CBT:Id_Centro_Costo del cbte para poder tomar aca    

*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Trans				INT
DECLARE @pFlagRegenerar			TINYINT
DECLARE @pRtaMsjStored			TINYINT					--01/12/2022 Agregado	

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pFlagRegenerar				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagRegenerar')), 0)
SET @pRtaMsjStored				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'RtaMsjStored')), 0)
/*FIN Variables recibidas por parÔö£ãÆmetro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion de Variables*/
DECLARE @Flag_Compromete_Asientos	SMALLINT
DECLARE @Flag_Compromete_Factura	SMALLINT
DECLARE @Flag_Compromete_Trans_Fondos SMALLINT
DECLARE @Flag_Compromete_Recibos	SMALLINT

DECLARE @Fecha_Cbte					DATETIME
DECLARE @Id_Cliente					INT
DECLARE @Id_Tipo_Cbte				CHAR(4)
DECLARE @Id_Cta_Contable			INT
DECLARE @Alias						INT
DECLARE @Id_Asiento					INT
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Id_Ejercicio_Corresp		INT
DECLARE @Id_Plan_Cta_Corresp		INT
DECLARE @Imp_Total_Cbte				DECIMAL(12,2)
DECLARE @Debe						DECIMAL(12,2)
DECLARE @Haber						DECIMAL(12,2)
DECLARE @Id_Producto				VARCHAR(14)
DECLARE @Id_Tipo_Reten				VARCHAR(10)
DECLARE @NroItem					SMALLINT
DECLARE @CMC_UltItem				SMALLINT
DECLARE @CMC_UltId_Periodo_Caja		INT
DECLARE @CMC_Id_Concepto			INT
DECLARE @VAL_UltId_Valor			INT
DECLARE @VAL_UltId_Periodo_Caja		INT
DECLARE @VAL_Id_Tipo_Val			CHAR(3)
DECLARE @Id_Cond_Pago				SMALLINT
DECLARE @VAL_Id_Periodo_Caja		INT
DECLARE @CP_Id_Caja					INT
DECLARE @ID_TARJETA                 VARCHAR(10)
DECLARE @ID_CTA_BANCO               SMALLINT
DECLARE @pId_Trans_ORIGEN            INT
DECLARE @Parametro_Asiento_Vtas_Ptos INT
DECLARE @Cbtes_Items_Imp_Final		DECIMAL(12,2)
DECLARE @Id_Caja					INT
DECLARE @Imp_Original				DECIMAL (12,2) -- Agregado el 20220527
DECLARE @IMPORTE					DECIMAL (12,2) -- Agregado el 20220527
DECLARE @Importe_Fpago				DECIMAL (12,2) -- Agregado el 20220712
DECLARE @Total_Debe					DECIMAL (12,2) -- Agregado el 20220712 

/*declaracion asiento de compras*/

DECLARE @Signo	INT
		,@Flag_Compromete_Compras SMALLINT
		,@Id_Iva	CHAR(3)
		,@Alias_D SmallInt
		,@Alias_H SmallInt
		,@ID_Cta_Debe Int
		,@ID_Cta_Haber Int
		,@IMP_GRAVADO DECIMAL(12,2)
		,@IMP_IVA DECIMAL(12,2)
		,@Id_Proveedor	INT
		,@Fecha	DATETIME
		,@ASI_Comp_x_Items INT
		,@Alias_D_IVA INT 
		,@ID_Cta_Debe_IVA INT
		,@IMPORTE_NC DECIMAL(12,2)


/*FIN Declaracion de Variables*/


BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Ctas_Contables_Generar'
		PRINT 'ParÔö£ãÆmetros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + ' Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) + ' FlagRegenerar: ' + CONVERT(VARCHAR(10), @pFlagRegenerar)
	END

	/*===================================================================*/

	IF(@pId_Trans = 0)   RAISERROR ('Id_trans can not be zero.', 16,  1 ) 
	
	/*===================================================================*/	

	SET @Parametro_Asiento_Vtas_Ptos = dbo.CF_xParam('Asiento_Vtas_Ptos')

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Parametro_Asiento_Vtas_Ptos: ' + CONVERT(VARCHAR(10), @Parametro_Asiento_Vtas_Ptos)
	END

	/*===================================================================*/	

	IF(@pFlagRegenerar = 1)
	BEGIN
		DELETE FROM Cbtes_Ctas_Contables WHERE Id_Trans = @pId_Trans
	END


	/*************************************************************************************************/

	SET @Id_Tipo_Cbte	= (SELECT Id_Tipo_Cbte FROM Cbtes WHERE Id_Trans = @pId_Trans)

	SELECT  @Flag_Compromete_Asientos		= ISNULL(Compromete_Asientos, 0),
			@Flag_Compromete_Factura		= ISNULL(Compromete_Factura, 0),
			@Flag_Compromete_Trans_Fondos	= ISNULL(Compromete_Trans_Fondos, 0),
			@Flag_Compromete_Recibos		= ISNULL(Compromete_Recibos, 0),
            @Flag_Compromete_Compras        = ISNULL(Compromete_Compras, 0)
	FROM Cbtes_Tipos
	WHERE 
	Id_Tipo_Cbte = @Id_Tipo_Cbte

	/*************************************************************************************************/

	IF(@Flag_Compromete_Asientos = 0)
	BEGIN
		IF @pFlagUsarTrans <> 0 
		BEGIN
			COMMIT
		END
		SET @rtaMsjStored = 'El Cbte. no Genera Asiento'

		IF (@pRtaMsjStored = 0)
		BEGIN

			SELECT	 0				AS ErrorNumber 
					,0				AS ErrorSeverity  
					,0				AS ErrorState 
					,0				AS ErrorProcedure  
					,0				AS ErrorLine		
					,@rtaMsjStored	AS ErrorMessage
		END
			
		RETURN 0
	END

	/*************************************************************************************************/

	SELECT  @Id_Cliente		= ISNULL(Id_Cliente, 0),
			@Fecha_Cbte		= ISNULL(Fecha, '19000101'),
			@Imp_Total_Cbte	= ISNULL(Imp_Total, 0)
			FROM Cbtes
			WHERE 
			Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SET @Id_Ejercicio_Corresp = (SELECT Id_Ejercicio FROM Plan_Ctas_Ejercicios WHERE Fecha_Inicio <= @Fecha_Cbte AND DATEADD(dd, 1, Fecha_Cierre) > @Fecha_Cbte)
	SET @Id_Plan_Cta_Corresp = (SELECT Id_Plan_Cta FROM Plan_Ctas WHERE Id_Ejercicio = @Id_Ejercicio_Corresp)
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Nro. de Ejercicio: ' + CONVERT(VARCHAR(10), @Id_Ejercicio_Corresp) + '. Nro. Plan de Cuenta: ' + CONVERT(VARCHAR(10), @Id_Plan_Cta_Corresp)
	END

	IF(@Flag_Compromete_Factura = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Compromete Factura'
		END
	
		SET @Id_Cond_Pago = (SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
		IF(@Id_Cond_Pago NOT IN (1)) /*Si no es contado*/
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Cond. Pago NO ES CONTADO. @Id_Cond_Pago: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago)
			END

			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion Cuenta Contable: DEBE'
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Parametro_Asiento_Vtas_Ptos: ' + CONVERT(VARCHAR(10), @Parametro_Asiento_Vtas_Ptos)
			END

			IF(@Parametro_Asiento_Vtas_Ptos = 0)
			BEGIN
				SET @Alias = (SELECT ISNULL(Id_Alias_Cta_Cont_Venta, 0) FROM Clientes WHERE Id_Cliente = @Id_Cliente)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
                IF (SELECT 1 FROM Pla_Ctas_Cuentas_Contables WHERE Id_Cta_Contable = @Id_Cta_Contable AND Tipo IN ('-','+') ) = 1
				   SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Clientes WHERE Id_Cliente = @Id_Cliente),'')
                ELSE
				   SET @Id_Centro_Costo ='' /* 30/6/22 Pongo en CC vacio en el Debe*/ 

				SET @Debe = @Imp_Total_Cbte
				SET @NroItem = 1
				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
				END

				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,			0/*Haber*/,			''/*Observacion*/,
				@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
				@NroItem)

			END
			ELSE
			BEGIN
				DECLARE curGenCtaCteDebexProduc CURSOR FOR 							
				SELECT DISTINCT Id_Producto, SUM(Imp_Final) AS Imp_Final FROM Cbtes_Items WHERE Id_Trans = @pId_Trans GROUP BY Id_Producto
				--05/05/2022 Se agrupa para items de meses continuos, antes ponia en el debe solo un item por el monto de un periodo
				--SELECT DISTINCT Id_Producto, Imp_Final FROM Cbtes_Items WHERE Id_Trans = @pId_Trans
				SET @NroItem = 0
				OPEN curGenCtaCteDebexProduc
				FETCH NEXT FROM curGenCtaCteDebexProduc INTO @Id_Producto, @Cbtes_Items_Imp_Final
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Id_Producto: ' + @Id_Producto + '. Imp_Final: ' + CONVERT(VARCHAR(20), @Cbtes_Items_Imp_Final)
					END

					SET @Alias = (SELECT ISNULL(Id_Alias_Cta_Deudores, 0) FROM Productos WHERE Id_Producto = @Id_Producto)
					SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
					--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)

	                IF (SELECT 1 FROM Pla_Ctas_Cuentas_Contables WHERE Id_Cta_Contable = @Id_Cta_Contable AND Tipo IN ('-','+') ) = 1
					   SET @Id_Centro_Costo = ISNULL((SELECT ISNULL(Id_Centro_Costo, '') FROM Productos WHERE Id_Producto = @Id_Producto),'')
	                ELSE
					   SET @Id_Centro_Costo ='' /* 30/6/22 Pongo en CC vacio en el Debe*/ 

				   	SET @Debe = @Cbtes_Items_Imp_Final
					SET @NroItem = @NroItem + 1
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
					END

					INSERT INTO Cbtes_Ctas_Contables
					(Id_Trans,		Id_Cta_Contable,	Fecha,
					Debe,			Haber,				Observacion,
					Alias,			Id_Asiento,			Id_Centro_Costo,
					Item)
					VALUES									
					(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
					@Debe,			0/*Haber*/,			''/*Observacion*/,
					@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
					@NroItem)

					FETCH NEXT FROM curGenCtaCteDebexProduc INTO @Id_Producto, @Cbtes_Items_Imp_Final
				END 
				CLOSE curGenCtaCteDebexProduc;
				DEALLOCATE curGenCtaCteDebexProduc;
			END
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Cond. Pago ES CONTADO'
			END

			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion Cuenta Contable: DEBE'
			END

			SET @VAL_Id_Periodo_Caja = ISNULL((SELECT MAX(Id_Periodo_Caja) FROM Valores_Mov WHERE Id_Trans = @pId_Trans), 0)		
			SET @CP_Id_Caja = ISNULL((SELECT Id_Caja FROM Cajas_Periodos WHERE Id_Periodo_Caja = @VAL_Id_Periodo_Caja), 0)		
			SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), 0)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Alias = @Alias AND Id_Plan_Cta = @Id_Plan_Cta_Corresp)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Cajas WHERE Id_Caja = @CP_Id_Caja), '')
			SET @Debe = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
		
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe,			0/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
		END
	
		/*Insert: Cuenta Contable: HABER*/
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Generacion Cuenta Contable: HABER'
		END
	
		--PRINT 'Generacion de Items de Productos'
		DECLARE curGenCtaCteHaber CURSOR FOR 
			SELECT DISTINCT Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaber
		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Alias_Cta_Cont FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Productos WHERE Id_Producto = @Id_Producto),'')
			SET @Haber = (SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto = @Id_Producto)
			SET @NroItem = @NroItem + 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Producto: ' + @Id_Producto + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		END 
		CLOSE curGenCtaCteHaber;
		DEALLOCATE curGenCtaCteHaber;
		/*FIN Insert: Cuenta Contable: HABER*/

		IF(@pModoDebug = 1)
		BEGIN
	 		PRINT 'Generacion de Items de Percepciones'	
		END

		DECLARE curGenCtaCteHaberPercep CURSOR FOR 
			SELECT DISTINCT Id_Tipo_Reten	FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaberPercep
		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ''
			SET @Haber = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1			
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteHaberPercep;
		DEALLOCATE curGenCtaCteHaberPercep;

		IF(@pModoDebug = 1)
		BEGIN	
			PRINT 'Generacion de Items de Iva'
		END
		SET @Alias = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Iva_Debito_Fiscal')
		SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
		--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
		SET @Id_Centro_Costo = ''
		SET @Haber = (SELECT SUM(Imp_Iva) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto IN (SELECT Id_Producto FROM Productos WHERE Id_Iva IN (SELECT Id_Iva FROM Productos_TasaIva WHERE (Porc1 <> 0 OR Porc1 IS NOT NULL))))
	
		IF(@Haber <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
			
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END
	
		----PRINT 'FIN Compromete Factura'
	END /*IF(@Flag_Compromete_Factura = 1)*/

/*************************************************************************************************/

IF(@Flag_Compromete_Factura =-1) /*NC*/
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Compromete Factura -1 ES NC'
		END

		SET @Id_Cond_Pago = (SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
		IF(@Id_Cond_Pago NOT IN (1)) /*Si no es contado*/
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Cond. Pago NO ES CONTADO. @Id_Cond_Pago: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago)
			END
		
			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion Cuenta Contable: DEBE'
			END
			SET @Alias = (SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Clientes WHERE Id_Cliente = @Id_Cliente),'')
			SET @Haber = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0,			    @Haber/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: HABER (SI la Cond. Pago NO es Contado)*/
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Cond. Pago ES CONTADO'
			END
		
			/*Insert: Cuenta Contable: HABER (SI la Cond. Pago ES Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacion Cuenta Contable: HABER'
			END
			SET @VAL_Id_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Trans = @pId_Trans), 0)		
			SET @CP_Id_Caja = ISNULL((SELECT Id_Caja FROM Cajas_Periodos WHERE Id_Periodo_Caja = @VAL_Id_Periodo_Caja), 0)		
			SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), 0)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Alias = @Alias AND Id_Plan_Cta = @Id_Plan_Cta_Corresp)
			SET @Id_Centro_Costo = ISNULL((SELECT  Id_Centro_Costo FROM Cajas WHERE Id_Caja = @CP_Id_Caja), '')
			SET @Haber = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
		
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0,			    @Haber/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: HABER (SI la Cond. Pago ES Contado)*/
		END
	
		/*Insert: Cuenta Contable: DEBE*/
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Generacion Cuenta Contable: DEBE'
		END
	
		--PRINT 'Generacion de Items de Productos'
		DECLARE curGenCtaCteHaber CURSOR FOR 
			SELECT DISTINCT Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaber
		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Alias_Cta_Cont FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = (SELECT Id_Centro_Costo FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Debe = (SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto = @Id_Producto)
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Producto: ' + @Id_Producto + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,		0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		END 
		CLOSE curGenCtaCteHaber;
		DEALLOCATE curGenCtaCteHaber;
		/*FIN Insert: Cuenta Contable: DEBE*/

		IF(@pModoDebug = 1)
		BEGIN	
			PRINT 'Generacion de Items de Percepciones'	
		END

		DECLARE curGenCtaCteHaberPercep CURSOR FOR 
			SELECT DISTINCT Id_Tipo_Reten	FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaberPercep
		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ''
			SET @Debe = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,		0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteHaberPercep;
		DEALLOCATE curGenCtaCteHaberPercep;
	
		----PRINT 'Generacion de Items de Iva'
		SET @Alias = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Iva_Debito_Fiscal')
		SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
		--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
		SET @Id_Centro_Costo = ''
		SET @Debe = (SELECT SUM(Imp_Iva) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto IN (SELECT Id_Producto FROM Productos WHERE Id_Iva IN (SELECT Id_Iva FROM Productos_TasaIva WHERE (Porc1 <> 0 OR Porc1 IS NOT NULL))))
	
		IF(@Debe <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,	0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END
		IF(@pModoDebug = 1)
		BEGIN	
			PRINT 'FIN Compromete Factura -1 '
		END
	END /*IF(@Flag_Compromete_Factura = -1  NC)*/

/*************************************************************************************************/

	IF(@Flag_Compromete_Trans_Fondos = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Compromete Transferencia de Fondos'
		END

		/*Insert: Cuenta Contable: DEBE*/
		----PRINT 'Generacion Cuenta Contable: DEBE'
		SET @CMC_UltItem = ISNULL((SELECT MAX(Item) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Cajas_Mov_Conceptos. Ult. Item Generado: ' + CONVERT(VARCHAR(10), @CMC_UltItem)
	
		IF(@CMC_UltItem <> 0)
		BEGIN
			SET @CMC_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Item = @CMC_UltItem), 0)
		
			----PRINT 'Generacion de Items por cada concepto del Periodo de Caja: ' + CONVERT(VARCHAR(10), @CMC_UltId_Periodo_Caja)
			DECLARE curGenCtaCteDebe_CMC CURSOR FOR 
				SELECT DISTINCT Id_Concepto FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans
								AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja
		
			SET @NroItem = 0
		
			OPEN curGenCtaCteDebe_CMC
			FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			WHILE @@FETCH_STATUS = 0
			BEGIN
			    SET @Haber = 0
				SET @debe = 0
				SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Conceptos WHERE Id_Concepto = @CMC_Id_Concepto),0)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)	
				SET @Debe = (SELECT ISNULL(SUM(Importe), 0) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Id_Concepto = @CMC_Id_Concepto AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Concepto: ' + CONVERT(VARCHAR(10), @CMC_Id_Concepto) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				 Debe,			Haber,				Observacion,
				 Alias,			Id_Asiento,			Id_Centro_Costo,
				 Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				 @Debe,			@Haber,			''/*Observacion*/,
				 @Alias,			0/*Id_Asiento*/,	''/*Id_Centro_Costo*/,
				 @NroItem)

				FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			END 
			CLOSE curGenCtaCteDebe_CMC;
			DEALLOCATE curGenCtaCteDebe_CMC;
		END /*IF(@CMC_UltItem <> 0)*/
	
		/*Insert: Cuenta Contable: HABER*/
		----PRINT 'Generacion Cuenta Contable: HABER'
		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
	
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
			SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Valor = @VAL_UltId_Valor), 0)
		
			----PRINT 'Generacion de Items por cada Id_Tipo_Val del Periodo de Caja: ' + CONVERT(VARCHAR(10), @VAL_UltId_Periodo_Caja)
			DECLARE curGenCtaCteHaber_Val CURSOR FOR 
				SELECT DISTINCT Id_Tipo_Val 
				FROM Valores 
				WHERE 
				Id_Trans = @pId_Trans
				AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja
		
			OPEN curGenCtaCteHaber_Val
			FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tipos WHERE Id_Tipo_Val = @VAL_Id_Tipo_Val), 0)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
				SET @Haber = (SELECT SUM(Importe) FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Tipo_Val = @VAL_Id_Tipo_Val AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			END 
			CLOSE curGenCtaCteHaber_Val;
			DEALLOCATE curGenCtaCteHaber_Val;		
		END
	
		----PRINT 'FIN Compromete Transferencia de Fondos'
	END /*IF(@Flag_Compromete_Trans_Fondos = 1)*/

	IF(@Flag_Compromete_Recibos = 1)
	BEGIN
	    DECLARE @Tomar_Asiento_Cbte SMALLINT 
		SET @Tomar_Asiento_Cbte = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Tomar_Asiento_Cbte') 

	    SET @NroItem = 1	
		----PRINT 'Compromente Recibos'
		
		----PRINT 'Generacion Cuenta Contable: DEBE'

		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores_Mov WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
	
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
			SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE  Id_Valor = @VAL_UltId_Valor), 0)
		
			----PRINT 'Generacion de Items por cada Id_Tipo_Val del Periodo de Caja: ' + CONVERT(VARCHAR(10), @VAL_UltId_Periodo_Caja)
			DECLARE curGenCtaDEBE_Val CURSOR FOR 
					SELECT DISTINCT V.Id_Tipo_Val,ISNULL(V.ID_TARJETA,''),ISNULL(V.ID_CTA_BANCO,0)
					FROM Valores_MOV M, VALORES V 
					WHERE 
					M.Id_Trans = @pId_Trans
					AND M.ID_VALOR = V.ID_VALOR
					AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja



		
			OPEN curGenCtaDEBE_Val
			FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO
			WHILE @@FETCH_STATUS = 0
			BEGIN
			    SET @Alias = 0 
			    IF @VAL_Id_Tipo_Val = 'TAR'
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tarjetas_Cred WHERE ID_TARJETA = @ID_TARJETA), 0)
                   END

					/********AGREGO 2020-02-08**********************************************/
				   IF @VAL_Id_Tipo_Val = 'EFE'
				   BEGIN
						SET @Id_Caja = ISNULL((SELECT ISNULL(id_Caja,0) FROM Cajas_Periodos WHERE id_periodo_caja= @VAL_UltId_Periodo_Caja), 0)
						SET @Alias = ISNULL((SELECT ISNULL (id_alias_cta_cont,0) FROM Cajas_Ctas_Cont WHERE Id_caja=@Id_Caja AND  id_tipo_val='EFE'), 0)
						IF(@Alias = 0)
						BEGIN
							SET @Alias = ISNULL((SELECT ISNULL(id_cta_contable,0) FROM  cajas  WHERE id_caja= @Id_Caja),0)
						END
                   END
					/***************   FIN   EFE *********************/

			    IF @VAL_Id_Tipo_Val = 'DB'
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Bancos_Ctas WHERE Id_Cta_Banco = @ID_CTA_BANCO), 0)
                   END	    
				IF @Alias = 0  
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tipos WHERE Id_Tipo_Val = @VAL_Id_Tipo_Val), 0)
                   END


				SET @Id_Cta_Contable = 	  (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))
				SET @NroItem = @NroItem + 1
			    SET @Id_Centro_Costo = ''
			    SET @Debe = (SELECT SUM(V.Importe) FROM Valores V, Valores_Mov M WHERE M.Id_Trans = @pId_Trans AND M.id_valor = V.Id_Valor And V.Id_Tipo_Val = @VAL_Id_Tipo_Val AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja AND ISNULL(V.Id_Tarjeta,'') = @ID_TARJETA AND ISNULL(V.Id_Cta_Banco,0) = @Id_Cta_Banco)
	
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,		0,				''/*Observacion*/,
				@Alias,		0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO
			END 
			CLOSE curGenCtaDEBE_Val;
			DEALLOCATE curGenCtaDEBE_Val;		
		END

		/*Insert: Cuenta Contable: HABER*/
		----PRINT 'Generacion Cuenta Contable: HABER'
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
		
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
		    IF @Tomar_Asiento_Cbte = 0
			BEGIN
				SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Valor = @VAL_UltId_Valor), 0)
				
				SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
				SET @Id_Cta_Contable = (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))
				SET @Haber = (SELECT SUM(V.Importe) FROM Valores V, Valores_Mov M WHERE M.Id_Trans = @pId_Trans AND M.id_valor = V.Id_Valor  AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja )
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)
		    END
		   ELSE
			BEGIN
			SELECT * INTO #CTAS_AUX FROM CBTES_CTAS_CONTABLES WHERE ID_TRANS = 1
			DELETE #CTAS_AUX

					
			-- RESPONSABLE AGUSTIN BARRAZA
			-- Tabla temporal que se pasa al cursor // 2022.06.01
			CREATE TABLE #CBTES_APLICA_AUX (
			Id_Trans		BIGINT,
			Id_Trans_D		BIGINT
			)
			
			-- RESPONSABLE AGUSTIN BARRAZA
			-- Validacion para contemplar casos en los cuales NO EXISTE registro en cbtes aplica (pagos a cuenta) // 2022.06.01
			IF EXISTS(SELECT TOP 1 ID_TRANS FROM Cbtes_Aplica WHERE ID_TRANS_D = @pId_Trans)
			BEGIN
				
				INSERT INTO #CBTES_APLICA_AUX
				SELECT Id_Trans, id_Trans_D  FROM Cbtes_Aplica WHERE ID_TRANS_D = @pId_Trans
	
			END
			ELSE
			BEGIN
			
				INSERT INTO #CBTES_APLICA_AUX
				SELECT Id_Trans_D AS Id_Trans , Id_Trans_D  FROM Cbtes_Aplica WHERE id_trans = 1
				UPDATE #CBTES_APLICA_AUX SET Id_Trans_D = @pId_Trans
	
			END
			
			DECLARE curGenCtaDEBE_FAC_APLIC2 CURSOR FOR 
			
			-- Colocamos DISTINCT para casos en los cuales tenemos repetido el Td_trans 
			SELECT DISTINCT ID_TRANS
			FROM #CBTES_APLICA_AUX WHERE ID_TRANS_D = @pId_Trans


				OPEN curGenCtaDEBE_FAC_APLIC2
				FETCH NEXT FROM curGenCtaDEBE_FAC_APLIC2 INTO @pId_Trans_ORIGEN
				WHILE @@FETCH_STATUS = 0
				BEGIN
				/*    INSERT INTO #CTAS_AUX
					    SELECT * FROM CBTES_CTAS_CONTABLES WHERE ID_TRANS = @pId_Trans_ORIGEN AND DEBE <> 0

				    FETCH NEXT FROM curGenCtaDEBE_FAC_APLIC2 INTO  @pId_Trans_ORIGEN
		    	END 
*/

					-- RESPONSABLE AGUSTIN BARRAZA
					-- Se agrega filtro que contemple pagos a cuenta // 2022-05-27
					IF(@pId_Trans_ORIGEN = 0)
					
					BEGIN
					
						SET @pId_Trans_ORIGEN = @pId_Trans
						
						-- RESPONSABLE AGUSTIN BARRAZA
						-- Verificamos si hay registros en Cbtes_Aplica
						IF EXISTS(SELECT ISNULL(IMPORTE,0) FROM Cbtes_Aplica WHERE id_Trans_D = @pId_Trans_ORIGEN)
						BEGIN
							
							SET @IMPORTE = (SELECT ISNULL(IMPORTE,0) FROM Cbtes_Aplica WHERE id_Trans_D = @pId_Trans_ORIGEN AND ID_TRANS = 0)
						END
						
						ELSE
						BEGIN
							SET @IMPORTE = (SELECT ISNULL(IMPORTE,0) FROM Valores WHERE id_TRANS = @pId_Trans_ORIGEN)
						END
						
					END
					
					ELSE
					BEGIN
						-- RESPONSABLE AGUSTIN BARRAZA 
						-- SE AGREGA EL SUM POR CASOS EN LOS CUALES TENEMOS DOS REGISTROS EN CBTES_APLICA PARA LA MISMA Id_Trans
						SET @IMPORTE = (SELECT ISNULL(SUM(IMPORTE),0) FROM Cbtes_Aplica WHERE id_Trans = @pId_Trans_ORIGEN and id_trans_D = @pId_Trans)
					
					END
					
					-- INTERTO EN TABLA AUXILIAR
					INSERT INTO #CTAS_AUX
					SELECT * FROM CBTES_CTAS_CONTABLES WHERE ID_TRANS = @pId_Trans_ORIGEN AND DEBE <> 0
					
					 /*Agrego linea 2020.09.16*/
					SET @Imp_Original = (SELECT ISNULL(Imp_Total,0) FROM Cbtes WHERE id_Trans = @pId_Trans_ORIGEN)
					
					-- RESPONSABLE AGUSTIN BARRAZA
					-- CALCULO EN CASO DE QUE SEA UN PAGO PARCIAL, SE AGREGA EL IF // 2022.05.27
					IF(@Imp_Original<>@IMPORTE)
					BEGIN	
							/*Agrego linea 2020.09.16*/
							UPDATE #CTAS_AUX SET DEBE = Debe * @IMPORTE / @Imp_Original WHERE ID_TRANS = @pId_Trans_ORIGEN AND DEBE <> 0
					
					END
					-- RESPONSABLE AGUSTIN BARRAZA
					-- Modifico el alias en caso de pago a cuenta // 2022.05.27
					IF(@pId_Trans_ORIGEN = @pId_Trans)
					BEGIN
						UPDATE #CTAS_AUX SET Alias = (SELECT Valor_Integer FROM xParametros WHERE IdParametro = 'Alias_Pago_a_Cta')  WHERE ID_TRANS = @pId_Trans_ORIGEN AND DEBE <> 0			
					END
				
					FETCH NEXT FROM curGenCtaDEBE_FAC_APLIC2 INTO @pId_Trans_ORIGEN
					END
				
				
				-- SE AGREGA EL 20220712 --> RESPONSABLE AGUSTIN BARRAZA
				-- SE AGREGA FILRO PARA LOS CASOS EN LOS CUALES EL TOTAL DE LA FORMA DE PAGO SUPERA EL MONTO DE LOS CBTES APLICADOS, AHORA SE GENERA A CAJA ESE SALDO A FAVOR 20220712								
				
				SET @Importe_Fpago = (SELECT Importe FROM Valores WHERE Id_Trans = @pId_Trans)
				SET @Total_debe = (SELECT SUM(Debe) FROM #CTAS_AUX)
				
				IF(@Importe_Fpago <> @Total_debe)				
				BEGIN					
					SELECT TOP 1  * INTO #CTAS_AUX_F_PAGO FROM #CTAS_AUX 
					
					UPDATE #CTAS_AUX_F_PAGO 
					SET
					Alias = (SELECT Valor_Integer FROM xParametros WHERE IdParametro = 'Alias_Pago_a_Cta'),
					Debe = (@Importe_Fpago - @Total_debe)
				
					INSERT INTO #CTAS_AUX
					SELECT * FROM #CTAS_AUX_F_PAGO	
						
					DROP TABLE #CTAS_AUX_F_PAGO			
				END

				ALTER TABLE #CTAS_AUX ADD _Item INT IDENTITY(20,1)
		      	UPDATE #CTAS_AUX SET ID_TRANS = @pId_Trans,  Id_Cta_Contable = (SELECT dbo.CF_Cta_Cont(Alias, @Fecha_Cbte))
				UPDATE #CTAS_AUX SET Item = _Item, Id_Asiento = 0, Fecha = @Fecha_Cbte, HABER = DEBE
				UPDATE #CTAS_AUX SET DEBE = 0
				ALTER TABLE #CTAS_AUX DROP COLUMN _Item

				INSERT INTO CBTES_CTAS_CONTABLES 
				       SELECT * FROM #CTAS_AUX
                DROP TABLE #CTAS_AUX

			    CLOSE curGenCtaDEBE_FAC_APLIC2
			    DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 
	    	END
		
		DROP TABLE #CBTES_APLICA_AUX
		
		END ----PRINT 'FIN Compromente Recibos'
	END	
	/*===================================================================*/	
SELECT @Fecha = Fecha
        ,@Id_Tipo_Cbte = Id_Tipo_Cbte
		,@Id_Proveedor = Id_Proveedor  
		,@Importe = Imp_TOTAL
		,@IMP_GRAVADO = Imp_Gravado + Imp_Gravado2 + Imp_Gravado3 + Imp_Exento
		,@IMP_IVA = Imp_Iva + Imp_Iva2 + Imp_Iva3
		FROM CBTES WHERE Id_Trans = @pId_Trans

SET	@Id_Iva	= ISNULL((SELECT Id_Iva FROM Proveedores WHERE Id_Proveedor = @Id_Proveedor), 'I')
SET @Signo = @Flag_Compromete_Compras
SET @ASI_Comp_x_Items = CAST( dbo.CF_xParam('ASI_Comp_x_Items') AS INT)

DECLARE @Existe_Items SMALLINT
SET @Existe_Items = ISNULL((select count(*) from cbtes_items where  Id_Trans = @pId_Trans),0)

If @Existe_Items = 0
   SET @ASI_Comp_x_Items = 0


SET @Alias_D = (SELECT Id_Cta_Contable_D FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
SET @Alias_H = (SELECT Id_Cta_Contable_H FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Iva_Cre_Loc')

SET @ID_Centro_Costo = (SELECT ID_Centro_Costo FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)

SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
SET @ID_Cta_Haber = (SELECT dbo.CF_Cta_Cont(@Alias_H, @Fecha))
SET @NroItem = 0
/*FIN Asignacion Variables*/

IF @Flag_Compromete_Compras = 0
	BEGIN
	    SET @rtaMsjStored = 'No es un cbte de compra.'
		rollback
		SELECT	 1099		    	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,@rtaMsjStored		AS ErrorMessage
		RETURN 1
	END

IF ISNULL(@ASI_Comp_x_Items,0) = 0          --Asiento por cabecerad e cbte.
	BEGIN
		IF @SIGNO > 0
			BEGIN	
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha, Debe, Haber, Observacion, Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Debe,	@Fecha,@IMP_GRAVADO,	0,	'',@Alias_D,0,	@ID_Centro_Costo,1)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,@IMP_IVA,	0,	'',@Alias_D_IVA,0,	@ID_Centro_Costo,2)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Haber,	@Fecha,0,	@Importe,	'',@Alias_H,0,	@ID_Centro_Costo,3)
			END	
		ELSE
			BEGIN
			SET @IMPORTE_NC = @IMPORTE*-1
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_Haber,	@Fecha,@Importe_NC,	0,	'',@Alias_H,0,	@ID_Centro_Costo,1)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,0,@IMP_IVA,	'',@Alias_D_IVA,0,	@ID_Centro_Costo,2)
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_DEBE,	@Fecha,0,	@Importe_NC-@IMP_IVA,	'',@Alias_D,0,	@ID_Centro_Costo,3)
			END
	END
Else
	BEGIN
		--PRINT 'Compromete Factura COMPRA
		/*INICIO Insert: Cuenta Contable: DEBE*/		
		PRINT 'Generacion de Items de Productos'

		DECLARE curGenCtaContDEBE CURSOR FOR 

	    	SELECT P.Id_Alias_Cta_Asto_Costos,isnull(P.Id_Centro_Costo,'') AS Id_Centro_Costo,isnull(Sum(I.Imp_Gravado*@Signo),0) AS Imp_Gravado
	    	FROM Cbtes_Items i, Productos P
		    WHERE 
		    Id_Trans = @pId_Trans
	     	and I.id_Producto = P.Id_Producto
		    group by P.Id_Alias_Cta_Asto_Costos,P.Id_Centro_Costo

		    PRINT 'Generacion select del cursor'

		OPEN curGenCtaContDEBE
		FETCH NEXT FROM curGenCtaContDEBE INTO @Alias_D,@Id_Centro_Costo,@IMPORTE
		WHILE @@FETCH_STATUS = 0
		BEGIN
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @NroItem = @NroItem + 1
		
			PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) +  '. Alias: ' + CONVERT(VARCHAR(10), @Alias_D) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Debe) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 


					INSERT INTO Cbtes_Ctas_Contables
					(Id_Trans,		Id_Cta_Contable,	Fecha,
					Debe,			Haber,				Observacion,
					Alias,			Id_Asiento,			Id_Centro_Costo,
					Item)
					VALUES									
					(@pId_Trans,	@ID_Cta_Debe,	@Fecha,
					@Importe/*Debe*/,		0,				''/*Observacion*/,
					@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
					@NroItem)


		FETCH NEXT FROM curGenCtaContDEBE INTO  @Alias_D,@Id_Centro_Costo,@IMPORTE
		END 

		CLOSE curGenCtaContDEBE
		DEALLOCATE curGenCtaContDEBE

		/*FIN Insert: Cuenta Contable: DEBE*/
	
		PRINT 'Generacion de Items de Percepciones'	

		DECLARE curGenCtaCteDEBEPercep CURSOR FOR 
		SELECT DISTINCT Id_Tipo_Reten 
		FROM Cbtes_Reten 
		WHERE 
		Id_Trans = @pId_Trans

		OPEN curGenCtaCteDEBEPercep
		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @Alias_D = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @Id_Centro_Costo = ''
			SET @IMPORTE = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1
		
			--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@ID_Cta_Debe,	@Fecha,
			@Importe/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteDEBEPercep
		DEALLOCATE curGenCtaCteDEBEPercep
	
		PRINT 'Generacion de Items de Iva'

		SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Iva_Cre_Loc')
        SET @ID_Centro_Costo = ''
        SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
	
		IF(@IMP_IVA <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,
			@IMP_IVA/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D_IVA,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END

		/*Insert: Cuenta Contable: HABER */
		--PRINT 'Generacion Cuenta Contable: HABER'

		SELECT @Importe = Imp_TOTAL	FROM CBTES WHERE Id_Trans = @pId_Trans

		SET @Id_Centro_Costo = (SELECT Isnull(Id_Centro_Costo,'') FROM Proveedores WHERE Id_PROVEEDOR = @ID_PROVEEDOR)
		SET @NroItem = @NroItem + 1
		--PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias_H) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Haber) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
		INSERT INTO Cbtes_Ctas_Contables
		(Id_Trans,		Id_Cta_Contable,	Fecha,
		Debe,			Haber,				Observacion,
		Alias,			Id_Asiento,			Id_Centro_Costo,
		Item)
		VALUES									
		(@pId_Trans,	@ID_Cta_Haber,	@Fecha,
		0,@Importe ,			''/*Observacion*/,
		@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
		@NroItem)
		/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
	

	
		--PRINT 'FIN Compromete COMPRAS'
	END /*IF(@Flag_Compromete_cOMPRAS = 1)*/

   /*===================================================================*/		
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END
	
	/*===================================================================*/	

	IF (@pRtaMsjStored = 0)
	BEGIN

		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT') +
									'}'

		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage
	END 

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Ctas_Contables_Generar'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo
	
	IF ISNULL(@pFlagUsarTrans,0) <> 0 
	BEGIN
		ROLLBACK
	END

	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber') ) = -1
	   DEALLOCATE curGenCtaCteHaber		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaber 
	   DEALLOCATE curGenCtaCteHaber		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaberPercep') ) = -1
	   DEALLOCATE curGenCtaCteHaberPercep		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaberPercep') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaberPercep
	   DEALLOCATE curGenCtaCteHaberPercep		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteDebe_CMC') ) = -1
	   DEALLOCATE curGenCtaCteDebe_CMC		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteDebe_CMC') ) = 1
	BEGIN
	   CLOSE curGenCtaCteDebe_CMC
	   DEALLOCATE curGenCtaCteDebe_CMC 		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber_Val') ) = -1
	   DEALLOCATE curGenCtaCteHaber_Val		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber_Val') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaber_Val
	   DEALLOCATE curGenCtaCteHaber_Val		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_Val') ) = -1
	   DEALLOCATE curGenCtaDEBE_Val		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_Val') ) = 1
	BEGIN
	   CLOSE curGenCtaDEBE_Val
	   DEALLOCATE curGenCtaDEBE_Val		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = -1
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = 1
	BEGIN
	   CLOSE curGenCtaDEBE_FAC_APLIC2
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 
	END
	---------------------------------------------------------------------------------------


	RETURN 9999
END CATCH

RETURN 0
